<?php if (!defined('NEOFRAG_CMS')) exit;
/**************************************************************************
Copyright © 2015 Michaël BILCOT & Jérémy VALENTIN

This file is part of NeoFrag.

NeoFrag is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

NeoFrag is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with NeoFrag. If not, see <http://www.gnu.org/licenses/>.
**************************************************************************/

class w_lol_c_index extends Controller_Widget
{
	public function index($settings = array())
	{
		$info = $this->network(htmlspecialchars('https://euw.api.pvp.net/api/lol/euw/v2.4/team/'.$settings['team'].'?api_key='.$settings['api']))->get()->{$settings['team']};

		$i = 0;
		$lolMatches = [];

		foreach ($info->matchHistory as $match)
		{
			if ($i++ < 3)
			{
				$lolMatches[] = array(
					'id'     => $match->gameId,
					'opteam' => $match->opposingTeamName,
					'kills'  => $match->kills,
					'death'  => $match->deaths,
					'win'    => $match->win,
					'date'   => date('d/m/Y H:i', $match->date / 1000)
				);
			}
		}

		return $this->css('lol')
					->panel()
					->heading($this->lang('lol'), 'fa-trophy')
					->body($this->view('index', [
						'tag'     => $info->tag,
						'name'    => $info->name,
						'matches' => $lolMatches
					]));
	}
}

/*
NeoFrag Alpha 0.1.3
./widgets/lol/controllers/index.php
*/