<?php if (!defined('NEOFRAG_CMS')) exit;
/**************************************************************************
Copyright © 2015 Michaël BILCOT & Jérémy VALENTIN

This file is part of NeoFrag.

NeoFrag is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

NeoFrag is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with NeoFrag. If not, see <http://www.gnu.org/licenses/>.
**************************************************************************/

class w_steam_c_index extends Controller_Widget
{
	public function index($settings = [])
	{
		$this	->css('steam')
				->js('jquery.knob')
				->js_load('$(\'.knob\').knob();');

		$xml = simplexml_load_file('http://steamcommunity.com/gid/'.$settings['group'].'/memberslistxml/?xml=1');

		if(!empty($xml) && $xml->groupDetails->groupName != '')
		{
			return $this->panel()
						->heading($this->lang('steamgroup'), 'fa-steam')
						->body($this->view('index', [
							'name'           => $xml->groupDetails->groupName,
							'url'            => $xml->groupDetails->groupURL,
							'avatar'         => $xml->groupDetails->avatarFull,
							'members'        => $xml->groupDetails->memberCount,
							'members_ingame' => $xml->groupDetails->membersInGame,
							'members_online' => $xml->groupDetails->membersOnline,
							'show_knob'      => $settings['show_knob'],
							'display'        => $settings['display']
						]))
						->footer_if($settings['show_summary'] == TRUE, '<h4>'.$this->lang('aboutthisgroup').' <b>'.$xml->groupDetails->groupName.'</b></h4><p>'.$xml->groupDetails->summary.'</p>', 'left');
		}
	}
}

/*
NeoFrag Alpha 0.1.6
./widgets/steam/controllers/index.php
*/