<?php if (!defined('NEOFRAG_CMS')) exit;
/**************************************************************************
Copyright © 2015 Michaël BILCOT & Jérémy VALENTIN

This file is part of NeoFrag.

NeoFrag is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

NeoFrag is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with NeoFrag. If not, see <http://www.gnu.org/licenses/>.
**************************************************************************/

class w_coc_c_index extends Controller_Widget
{
	public function index($settings = [])
	{
		$info = $this	->network('https://api.clashofclans.com/v1/clans/'.str_replace('#', '%25', $settings['clan']))
						->header('Authorization: Bearer '.$settings['api'])
						->get();

		return $this->css('coc')
					->panel()
					->heading($this->lang('coc'), 'fa-shield')
					->body($this->view('index', [
						'tag'     => $info->tag,
						'name'    => $info->name,
						'avatar'  => $info->badgeUrls->large,
						'level'   => $info->clanLevel,
						'win'     => $info->warWins,
						'score'   => $info->clanPoints,
						'members' => $info->members
					]));
	}
}

/*
NeoFrag Alpha 0.1.6
./widgets/coc/controllers/index.php
*/